<?php
/**
 * Template Name: Liftoff News
 * @since caporil 3.226.0
 **/
get_header ();

function caporil_liftoff_news_loop_callback( $show_info, $heading_callback ) {
	$pieces = explode ( ' ', get_the_title () );
	$year = ( int ) array_pop ( $pieces ); ?>
	<div class="wp-caption entry-title liftoff">
		<h1> The Journal of Space Achievement <?php echo $year; ?></h1>
		<p style="font-size: x-small">Recording the events of <?php echo $year; ?>
	</div>
	<article id="post-<?php the_ID(); ?>" <?php post_class( array( 'post', basename(get_page_template_slug(), '.php') ) ); ?>>
		<?php the_content(); ?>
	</article>
	<div class="post liftoff-news-budget">
		<h2>Financial summary as of 1<sup>st</sup> January <?php echo $year+1 ?></h2>
		<?php $liftoffAgencies = array("SMAUG","SARSA","GOSsiP","SHADO","ASA"); $liftoffLinks = false; ?>
		<table>
			<tr><th>Agency</th><th>Cash in hand</th>
			<?php if (basename(get_page_template_slug(), '.php') === 'liftoff-news'): ?>
				<th>Expected Budget for <?php echo $year+2 ?></th>
			<?php endif; ?>
			</tr>
			<?php foreach ($liftoffAgencies as $liftoffAgency) : ?>
				<tr>
					<?php $liftoffAgencyLink = get_post_meta( get_the_ID(), $liftoffAgency . '_LINK', true); ?>
					<td>
						<?php if (! empty ( $liftoffAgencyLink )) :
							$liftoffLinks = true; ?>
							<a href="<?php echo $liftoffAgencyLink; ?>">
						<?php endif; ?>
						<?php echo get_post_meta( get_the_ID(), $liftoffAgency . '_NAME', true); ?>
						<?php if ( ! empty( $liftoffAgencyLink ) ) : ?>
							</a>
						<?php endif; ?>
					</td>
					<td><?php echo get_post_meta( get_the_ID(), $liftoffAgency . '_CIH', true); ?></td>
					<?php if (basename(get_page_template_slug(), '.php') === 'liftoff-news'): ?>
						<td><?php echo get_post_meta( get_the_ID(), $liftoffAgency . '_BUDGET', true); ?></td>
					<?php endif; ?>
				</tr>
			<?php endforeach; ?>
		</table>
	<?php if ( $liftoffLinks ) : ?>
		<p>Click on the name of the agency to see details on the agency's safety factors, astronaut roster and hardware stocks.
	<?php endif ?>
	<div class="clear"><hr/></div>
		<?php wp_nav_menu( array('theme_location' => 'liftoff', 'container_class' => 'liftoff-links') ); ?>
	</div><!-- post liftoff-news-budget --><?php
}

caporil_standard_page( array( 'sidebar_count' => 0, 'section_type' => 'single post', 'loop_callback' => 'caporil_liftoff_news_loop_callback' ) );

get_footer(); ?>
