<?php
/**
 * @since caporil 3.226.0
 *
 * Intended to be included in the various attachment php's to provide common logic
 * for the file metadata sections
 *
 * Expected variables to be set
 * $post - the wordpress post we're working on
 * $text_File - The word (or phrase) to be used in the heading for the metadata (i.e., it is expected to be capitalised)
 * $text_file - The word for the filetype to be used in text
 * $attachmentMeta - The metadata for the file
 * $isImageMeta - Set to true if the file is an image
 */
?>
<h3><?php echo $text_File; ?> Metadata</h3>
<dl>
<dt>Mimetype</dt><dd><?php echo get_post_mime_type( $post->ID ); ?></dd>
<?php
if (isset($attachmentMeta['filesize'])) {
	echo '<dt>File Size</dt><dd>' .number_format( $attachmentMeta['filesize']) . ' bytes</dd>';
} else if (isset($attachmentMeta['file'])) {
	echo '<dt>File Size</dt><dd>' . wp_filesize(wp_upload_dir()['basedir'] . '/' . $attachmentMeta['file']) . ' bytes </dd>';
}
if  ( $isImage ) {
	echo "<dt>Image Size</dt><dd>";
	if ( $imageScaled ) {
		$origSize = wp_getimagesize( $imageOriginalFile );
		echo $origSize[0] . "x" . $origSize[1];
	} else {
		echo $attachmentMeta['width'] . "x" . $attachmentMeta['height'];
	}
	echo "<br>Other Sizes: ";
	if ( $imageScaled ) {
		echo wp_get_attachment_link( $post->ID, '', false, false, "scaled(" . $attachmentMeta['width'] . "x" .$attachmentMeta['height'] . ")" ) . " " ;
	}
	$seenSizes = array();
	foreach( $attachmentMeta['sizes'] as $sizeName => $size ) {
		$sizeText = $size['width'] . "x" . $size['height'];
		if ( !in_array( $sizeText, $seenSizes)) {
			echo '<a href="' . image_downsize( $post->ID, $sizeName )[0] . '">' . $sizeName . "(" . $sizeText . ")</a> ";
			array_push( $seenSizes, $sizeText);
		}
	}
	echo "</dd>";
	if (isset( $attachmentMeta['image_meta']['created_timestamp'] ) && $attachmentMeta['image_meta']['created_timestamp'] !== '0' && $attachmentMeta['image_meta']['created_timestamp'] !== 0 ) {
		echo "<dt>Image created/taken</dt><dd>" . wp_date( get_option( 'date_format' ), $attachmentMeta['image_meta']['created_timestamp'] );
		if (isset( $attachmentMeta['image_meta']['camera'] ) && $attachmentMeta['image_meta']['camera'] !== '') {
			$model = $attachmentMeta['image_meta']['camera'];
			global $wpdb;
			$camera_table = $wpdb->prefix . 'caporil_cameras';
			$camera = $wpdb->get_col( "SELECT name FROM $camera_table WHERE model = '$model'" );
			if ( isset($camera) && isset($camera[0]) )
				$camera = $camera[0];
			else
				$camera = $model;
			echo " with " . $camera;
		}
		echo "</dd>";
	}
	if (isset( $attachmentMeta['image_meta']['focal_length'] ) && $attachmentMeta['image_meta']['focal_length'] !== '0' && $attachmentMeta['image_meta']['focal_length'] !== 0 ) {
		echo "<dt>Focal Length</dt><dd>" . $attachmentMeta['image_meta']['focal_length'] . "</dd>";
	}
	if (isset( $attachmentMeta['image_meta']['iso'] ) && $attachmentMeta['image_meta']['iso'] !== '0' && $attachmentMeta['image_meta']['iso'] !== 0 ) {
		echo "<dt>ISO</dt><dd>" . $attachmentMeta['image_meta']['iso'] . "</dd>";
	}
	if (isset( $attachmentMeta['image_meta']['shutter_speed'] ) && $attachmentMeta['image_meta']['shutter_speed'] !== '0' && $attachmentMeta['image_meta']['shutter_speed'] !== 0 ) {
		echo "<dt>Shutter Speed</dt><dd>" . $attachmentMeta['image_meta']['shutter_speed'] . "</dd>";
	}
}
$alttext = get_post_meta($post->ID, '_wp_attachment_image_alt', true);
$caption = get_the_excerpt();
$descrip = get_the_content();
if( is_string( $alttext ) && $alttext !== '') {
	echo "<dt>Alt Text</dt><dd>" . $alttext . "</dd>";
}
if( is_string( $caption ) && $caption !== '' && trim(strip_tags($descrip)) !== trim(strip_tags($caption)) ) {
	echo "<dt>Caption</dt><dd>" . get_the_excerpt() . "</dd>";
}
if( is_string( $descrip ) && $descrip !== '' ) {
	echo "<dt>Description</dt><dd>" . get_the_content() . "</dd>";
}
$terms = get_the_terms( $post->ID, 'attachment_tag' );
if ( $terms && ! is_wp_error( $terms ) ) {
	// First determine the possible copyright years (either from the tag or from the post's metadata
	foreach ( $terms as $term ) {
		if ( str_starts_with( $term->name, 'copyright-first-year-' ) ) {
			$publish = substr( $term->name, 21 );
		}
	}
	if ( !isset( $publish) ) {
		$publish = get_the_date( 'Y' );
	} else if ( strcmp( $publish,get_the_date( 'Y' ) ) !== 0 ) {
		$publish = $publish . ', ' . get_the_date( 'Y' );
	}

	// Substitute the copyright year(s) into the terms
	foreach ( $terms as $term ) {
		if ( isset( $term->description ) && !( empty( $term->description ) ) ) {
			$term->description = str_replace( '$years', $publish, $term->description );
		}
	}

	// Print out the first string with an '©' symbol at its beginning
	echo "<dt>Copyright Status</dt><dd>";
	$needspace = false;
	foreach( $terms as $term ) {
		if ( isset( $term->description ) && !( empty( $term->description ) ) && str_starts_with( $term->description, '©' ) ) {
			if ( $needspace ) { echo ' '; }
			echo $term->description;
			$needspace = true;
			break;
		}
	}

	// And then term that doesn't start with an '©' symbol
	foreach( $terms as $term ) {
		if ( isset( $term->description ) && !( empty( $term->description ) ) && !str_starts_with( $term->description, '©' ) ) {
			if ( $needspace ) { echo ' '; }
			echo $term->description;
			$needspace = true;
		}
	}
	echo "</dd>";
	if (has_term('', 'mediatag')) {
		echo "<dt>Tags</dt>";
		echo "<dd>";  the_terms( $post->ID, 'mediatag', '<span class="tags">', ' ', '</span>');
	}
}
?>
</dl>
