<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta http-equiv="Content-Type" content="<?php bloginfo('html_type'); ?>; charset=<?php bloginfo('charset'); ?>" />
<?php if ( !is_home() ) : ?>
	<link rel="start" href="<?php echo esc_url( home_url() ); ?>" title="<?php bloginfo('name'); ?> Home" />
<?php endif; ?>
	<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<?php wp_body_open(); ?>
<?php $static = caporil_get_theme_option( 'static' ); ?>
<?php if (isset( $args['pane_class'] ) ) { $pane_class = $args['pane_class']; } else { $pane_class = ''; }?>
<header id="header" class="<?php echo $pane_class; if ( $static != "on" ) { echo ' with-search"'; } ?>">
	<div id="title" class="siteName">
		<a href="<?php echo esc_url( home_url() ); ?>" title="<?php bloginfo('name'); ?>"><?php bloginfo( 'name' ); ?></a>
	</div>
	<nav id="topnav">
		<ul>
			<?php wp_nav_menu( array( 'show_home' => 'Home','container' => ' ','items_wrap' =>'%3$s', 'theme_location' => 'primary', 'item_spacing' => 'discard') ); ?>
		</ul>
	</nav>
	<!-- #catnavi -->
	 <?php if ( $static != "on" ): ?>
		<search>
			<div class="search-inner hide">
				<form action="<?php echo esc_url( home_url('/') ); ?>" id="search" name="search">
					<input id="q" name="s" placeholder="Search" speech="" type="text" x-webkit-speech="">
				</form>
			</div>
			<div class="search-toggle"></div>
		</search>
	<?php endif; ?>
</header>