/*!
 * © 2022 David Vines
 *
 * domainOfTheAncients is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * any later version.
 *
 * domainOfTheAncients is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with domainOfTheAncients. If not, see https://www.gnu.org/licenses/gpl-2.0.html.
 */
/* global customElements */
/* exported ModalDialog */
class ModalDialog extends HTMLElement {
	constructor() {
		super();
		let oldChildren = [...this.children];

		this.replaceChildren(ModalDialog.wrapperTemplate.content.cloneNode(true));
		this._innerDiv= this.querySelector("div");
		this._innerDiv.append(...oldChildren);

		this._closeButton = this.querySelector(".close-modal-button");
		this._resizeTimer = null;
		this._onclose = null;
		this._closeButton.onclick = this.close.bind(this);
	}
	open() {
		this.classList.add("show-modal");
	}
	close() {
		this.classList.remove("show-modal");
		if (this._onclose) {
			this._onclose();
		}
	}
	get onclose() { return this._onclose; }
	set onclose(f) { this._onclose = f; }
}

ModalDialog.wrapperTemplate = document.createElement("template");
ModalDialog.wrapperTemplate.innerHTML = `
<div>
<span class="close-modal-button">&times;</span>
</div>
`;
customElements.define("modal-dialog",ModalDialog);