/*!
 * © 2021 David Vines
 *
 * sumoOyakata is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * any later version.
 *
 * sumoOyakata is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with sumoOyakata. If not, see https://www.gnu.org/licenses/gpl-2.0.html.
 */

/* exported Move */
class Move {
	constructor(name,ourStatFunction,theirStatFunction) {
		this._name = name;
		this._thac0 = {};
		this._ourStatFunction = ourStatFunction;
		this._theirStatFunction = theirStatFunction;
	}
	addCounterMove(move,thac0) {
		this._thac0[move.toString()] = thac0;
	}
	toString() {
		return this._name;
	}
	getOdds(theirMove,us,them) {
		const diff = this._ourStatFunction.call(us) - this._theirStatFunction.call(them);
		const thac0 = this._thac0[theirMove.toString()]-1;
		const adjthac0 = thac0 - diff/5;

		return 5*(21-adjthac0);
	}
}