/*!
 * © 2022 David Vines
 *
 * domainOfTheAncients is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * any later version.
 *
 * domainOfTheAncients is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with domainOfTheAncients. If not, see https://www.gnu.org/licenses/gpl-2.0.html.
 */
/* exported RangedCombo */
class RangedCombo {
	_getNode(id) {
		return (typeof id === "string" ? document.getElementById(id) : id);
	}
	constructor(sliderElementId,inputElementId) {
		this._slider = this._getNode(sliderElementId);
		this._input  = this._getNode(inputElementId);
		this._min = 0;
		this._max = 400;
		this._value = 0;
		this._listeners = [];
		this._oninput = null;

		this._resetSize();

		this._slider.oninput = this._changedSlider.bind(this);
		this._input.oninput = this._changedInput.bind(this);
	}
	get oninput() { return this._oninput; }
	set oninput(f) {
		if (this._oninput) {
			this.removeListener(this._oninput);
		}
		this._oninput = f;
		if (this._oninput) {
			this.addListener(this._oninput);
		}
	}
	get min() { return this._min; }
	set min(m) {this._min = m; this._resetSize(); }
	get max() { return this._max; }
	set max(m) { this._max = m; this._resetSize(); }
	get value() { return this._value; }
	set value(v) { this._value = v; this._resetSize(); }
	_resetSize() {
		if (this._value < this._min) this._value = this._min;
		if (this._value > this._max) this._value = this._max;
		this._slider.min = this._min; this._slider.value = this._value; this._slider.max = this._max;
		this._input.min  = this._min; this._input.value  = this._value; this._input.max  = this._max;
		this._fireListeners();
	}
	addListener(l) {
		this._listeners.push(l);
	}
	removeListener(l) {
		this._listeners = this._listeners.filter(f => f !== l);
	}
	_fireListeners() {
		for(let l of this._listeners) {
			l();
		}
	}
	_changedSlider() {
		this._changed(this._slider.value);
	}
	_changedInput() {
		this._changed(this._input.value);
	}
	_changed(newValue) {
		this.value = newValue;
	}
}