/*!
 * © 2022 David Vines
 *
 * domainOfTheAncients is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * any later version.
 *
 * domainOfTheAncients is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with domainOfTheAncients. If not, see https://www.gnu.org/licenses/gpl-2.0.html.
 */
/* exported Util */
var Util= {
	emptyList: function(id) {
		const element = (typeof id === "string" ? document.getElementById(id) : id);
		element.replaceChildren();
		return element;
	},
	replaceText: function(id, text) {
		let node = (typeof id === "string" ? document.getElementById(id) : id);
		node.replaceChildren(document.createTextNode(text));
	},
	toggleFields: function(fields) {
		for(let field of fields) {
			field.classList.toggle("hidden");
		}
	},
	addOption(select,text,data) {
		const option = document.createElement("option");
		option.append(text);
		if (data) {
			for(let key of Object.keys(data)) {
				option.dataset[key] = data[key];
			}
		}
		select.append(option);
		return option;
	},
	time_diff: function(from) {
		const diff = Math.floor(Math.abs(new Date().getTime() - from.getTime()) / 1000); // In seconds
		if (diff < 60) return "just now";
		if (diff < 120) return "a minute ago";
		if (diff < 3600) return Math.floor(diff / 60) + " minutes ago";
		if (diff < 7200) return "an hour ago";
		if (diff < 86400) return Math.floor(diff / 3600) + " hours ago";
		if (diff < 86400 * 2) return "yesterday";
		if (diff < 86400 * 6) return Intl.DateTimeFormat(undefined, { weekday: "long" }).format(from);
		if (new Date().getFullYear() === from.getFullYear()) return Intl.DateTimeFormat(undefined, { day: "numeric", month: "long" }).format(from);
		return Intl.DateTimeFormat(undefined, { day: "numeric", month: "short", year: "numeric" }).format(from);
	},
	next_time_diff: function(from) {
		const diff = Math.floor(Math.abs(new Date().getTime() - from.getTime()) / 1000); // In seconds
		if (diff < 3660) return 60;
		if (diff < 86400) return 3600;
		return null;
	}
};
