/*!
 * © 2022 David Vines
 *
 * domainOfTheAncients is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * any later version.
 *
 * domainOfTheAncients is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with domainOfTheAncients. If not, see https://www.gnu.org/licenses/gpl-2.0.html.
 */
/* globals Util, ALLTECHS, LinkedRange */
/* globals ResearchOrder */
/* exported PlayerResearch */
var PlayerResearch = {
	_player: null,
	_techControls: {},
	init: function() {
		for(let tech of ALLTECHS) {
			const prefix = tech.domPrefix;
			this._techControls[prefix] = new LinkedRange("research-amount-"+prefix+"-range",
				"research-amount-"+prefix+"-number",
				prefix+"ExpenditureRow",
				prefix+"ExpenditureCost",
				prefix+"ExpenditureCancel");
		}
	},
	setPlayer: function(player) {
		PlayerResearch._player = player;
		// Update for the favoured tech
		const favouredTech = ALLTECHS[PlayerResearch._player.indexOfFavouredTech];
		document.getElementById(favouredTech.domPrefix+"Favoured").classList.remove("hidden");
		this._techControls[favouredTech.domPrefix].multiplier = 0.5;
	},
	prepare: function(max) {
		// Report on the current tech levels
		PlayerResearch._player.forEachTech( (tech, research) => {
			const prefix = tech.domPrefix;
			this._techControls[prefix].value = 0;
			Util.replaceText(prefix+"Points",research);
			let level = tech.level(research);
			Util.replaceText(prefix+"Level",level);
			if (tech.moreResearchAvailable(research)) {
				Util.replaceText(prefix+"MorePoints",tech.pointsToNextLevel(research));
				Util.replaceText(prefix+"NextLevel",level+1);
			} else {
				document.getElementById(prefix+"NextLevelDiv").classList.add("hidden");
				document.getElementById(prefix+"NoMoreLevels").classList.remove("hidden");
			}
			while(level > 1) {
				document.getElementById(prefix+level).classList.remove("hidden");
				level--;
			}
		});

		// Set the initial research levels to zero (and set the max)
		const favouredTech = ALLTECHS[PlayerResearch._player.indexOfFavouredTech];
		for(let tech of ALLTECHS) {
			const prefix = tech.domPrefix;
			PlayerResearch._techControls[prefix].max = (tech == favouredTech ? max*2 : max);
			PlayerResearch._techControls[prefix].value = 0;
		}
	},
	getOrders: function() {
		const orders = [];
		for(let tech of ALLTECHS) {
			const prefix = tech.domPrefix;
			if (PlayerResearch._techControls[prefix].value) {
				orders.push(new ResearchOrder(tech,PlayerResearch._techControls[prefix].value));
			}
		}
		return orders;
	}
};